import Utilities.waveform_creator as wc
import Utilities.gui_creator as gc
import Utilities.plot_creator as pc
import Utilities.mccdaq_operations as mo
import threading 



board_num, low_chan, high_chan = 0, 0, 0
ai_range = mo.chan_range('bipolar_10')


label_x, label_y = 'Frequency (Hz)', 'Amplitude (V)'

root = gc.create_window(title='Spectrum Analyzer',
                        size='1000x500')
control_box, right_frame = gc.create_frames(root)

var_num, var_samp_freq = gc.digitizing_control(control_box)
var_trig = gc.trigger_control(control_box)
var_window = gc.window_control(control_box)

lbl_freq = gc.create_indicator(control_box,
                       label_1='Estimated Frequency (Hz)',
                       char_width=15)
lbl_amp = gc.create_indicator(control_box,
                       label_1='Estimated Amplitude',
                       char_width=15)

ax, canvas = pc.create_plot(right_frame)
pc.update_plot(ax, canvas, [], [], label_x, label_y)


def acquire_waveform():

    num, samp_freq = gc.get_dig_entries(var_num,
                                        var_samp_freq)    
    edge_option = gc.get_edge_option(var_trig)
    win_type = gc.get_window_option(var_window)
    
    num_points, rate = num, int(samp_freq)
    mo.config_digital_triggering(board_num, edge_option)

    memhandle, ctypes_array = mo.create_buffer(num_points)

    t = wc.create_time_data(num, samp_freq)


    while btn.cget('text') == 'Stop':    

        y = mo.read_waveform(board_num, low_chan, high_chan,
                             num_points, rate, ai_range,
                             memhandle, ctypes_array)

        win = wc.create_window(win_type, num)
        y = y*win

        freq_positive, amp_positive = wc.fft_mag_only(y, num,
                                                      samp_freq)

        pc.update_plot(ax, canvas, freq_positive, amp_positive,
                       label_x, label_y, marker='o')

        freq_est,amp_est = wc.estimated_freq_amp(freq_positive,
                                             amp_positive,
                                             num, win)
        lbl_freq.config(text=f'{freq_est:.2f}')
        lbl_amp.config(text=f'{amp_est:.2f}')

    mo.free_buffer(memhandle)

    return


def toggle():

    if btn.cget('text') == 'Start':
        btn.config(text='Stop')
    elif btn.cget('text') == 'Stop':
        btn.config(text='Start')

    t = threading.Thread(target=acquire_waveform)
    t.start()

    return

btn = gc.action_button(control_box, label='Start',
                       action=toggle)

root.mainloop()
